cd "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/"

use "hcn_only_adj_trends_diff tavg 2000.dta", clear

append using "hcn_only_raw_trends_diff tavg 2000.dta"
append using "crn_pairs tavg 2000.dta"

keep coef distance dataset adjustments
replace adjustments = "crn" if adjustments == ""

tempfile combined_data
save "`combined_data'", replace

clear
tempfile results
cap gen distance = .
keep if _n < 0
save "`results'", replace

forvalues distance = 50(10)2000 {
	quietly {
	use "`combined_data'", clear
	keep if distance >= `distance' - 50 & distance < `distance' + 50
	su coef if adjustments == "raw", detail
	local raw_sd = r(sd)
	su coef if adjustments == "adj", detail
	local adj_sd = r(sd)
	su coef if adjustments == "crn", detail
	local crn_sd = r(sd)
	clear
	set obs 1
	gen distance = `distance'
	gen raw_sd = `raw_sd'
	gen adj_sd = `adj_sd'
	gen crn_sd = `crn_sd'
	append using "`results'"
	save "`results'", replace
	}
}

use "`results'", clear	

cd "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/Images/"

#delimit ;
twoway 
	(line raw_sd distance, lcolor(blue) lwidth(medium))
	(line adj_sd distance, lcolor(red) lwidth(medium))
	(line crn_sd distance, lcolor(green) lwidth(medium))
    ,
    ytitle("Standard Deviation in Trend Difference (Deg. C)", size(medsmall))
    xtitle("Distance (miles)", size(medsmall))
  	xlabel(0(200)2000,labsize(medsmall))
  	ylabel(0(0.05)0.2, gmax glcolor(black) glpattern(dot) labsize(medsmall)) 
  	graphregion(color(white) lcolor(ebg))
	legend(region(fcolor(white) lcolor(white)) size(medsmall) position(6) label(1 "USHCN Raw") label(2 "USHCN Adjusted") label(3 "USCRN") order(1 2 3) col(3))
    plotregion( m(b=0) )
	;
#delimit cr
graph export "CRN HCN Pair Diff Stdev by Distance.png", replace width(1000)
